@extends('admin.layout.template')
@section('title','Order Details')

@section('content')

<div class="page-content">
     <div class="container-xxl">

          <div class="row">

               {{-- LEFT SIDE --}}
               <div class="col-xl-9 col-lg-8">

                    {{-- ORDER HEADER --}}
                    <div class="card">
                         <div class="card-body">

                           <div class="d-flex justify-content-between">

<div>
<h4 class="fw-medium text-dark">

#{{ $order->order_number }}

{{-- PAYMENT STATUS --}}
@if($order->payment_status == 'success')
<span class="badge bg-success-subtle text-success">Paid</span>

@elseif($order->payment_status == 'pending')
<span class="badge bg-warning-subtle text-warning">Pending</span>

@elseif($order->payment_status == 'failed')
<span class="badge bg-danger-subtle text-danger">Failed</span>

@endif

{{-- ORDER STATUS --}}
<span class="badge bg-info">{{ ucfirst($order->status) }}</span>

</h4>

<p class="mb-0">
Order Date :
{{ \Carbon\Carbon::parse($order->created_at)->format('d M Y h:i A') }}
</p>

</div>

<div>
<button class="btn btn-primary editOrder" data-id="{{ $order->id }}">Edit</button>

<button class="btn btn-danger refundOrder" data-id="{{ $order->id }}">Refund</button>

<button class="btn btn-warning returnOrder" data-id="{{ $order->id }}">Return</button>

<button class="btn btn-success updateStatus" 
        data-id="{{ $order->id }}" 
        data-status="processing">Processing</button>

</div>

</div>


                         </div>
                    </div>

                    {{-- PRODUCTS --}}
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Products</h4>
                         </div>

                         <div class="card-body">

                              <div class="table-responsive">
                                   <table class="table table-hover align-middle">

                                        <thead>
                                             <tr>
                                                  <th>Product</th>
                                                  <th>Qty</th>
                                                  <th>Price</th>
                                                  <th>Total</th>
                                             </tr>
                                        </thead>

                                        <tbody>

                                             @foreach($order->items as $item)

                                             <tr>

                                                  <td>
                                                       <div class="d-flex gap-2 align-items-center">

                                                            <img
                                                                 src="{{ optional($item->variant?->primaryImage)->image_path ? asset($item->variant->primaryImage->image_path) : asset('no-image.png') }}"
                                                                 width="60"
                                                                 class="rounded" />

                                                            <div>
                                                                 <p class="mb-0 fw-medium">{{ $item->product_name }}</p>
                                                            </div>

                                                       </div>
                                                  </td>

                                                  <td>{{ $item->quantity }}</td>
                                                  <td>₹ {{ number_format($item->price,2) }}</td>
                                                  <td>₹ {{ number_format($item->total,2) }}</td>

                                             </tr>

                                             @endforeach

                                        </tbody>
                                   </table>
                              </div>

                         </div>
                    </div>

                    {{-- TIMELINE --}}
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Order Timeline</h4>
                         </div>

                         <div class="card-body">

                              @foreach($order->statusHistory as $history)

                              <div class="border-start ps-3 mb-3">
                                   <h6 class="mb-1">{{ $history->status }}</h6>
                                   <p class="mb-0 text-muted">{{ $history->note }}</p>
                                   <small>
                                        {{ \Carbon\Carbon::parse($history->created_at)->format('d M Y h:i A') }}
                                   </small>
                              </div>

                              @endforeach

                         </div>
                    </div>

               </div>

               {{-- RIGHT SIDE --}}
               <div class="col-xl-3 col-lg-4">

                    {{-- ORDER SUMMARY --}}
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Order Summary</h4>
                         </div>

                         <div class="card-body">

                              <table class="table mb-0">
                                   <tr>
                                        <td>Sub Total</td>
                                        <td class="text-end">₹ {{ number_format($order->sub_total,2) }}</td>
                                   </tr>

                                   <tr>
                                        <td>Discount</td>
                                        <td class="text-end">₹ {{ number_format($order->discount,2) }}</td>
                                   </tr>

                                   <tr>
                                        <td>Delivery Fee</td>
                                        <td class="text-end">₹ {{ number_format($order->delivery_fee,2) }}</td>
                                   </tr>

                              </table>

                         </div>

                         <div class="card-footer d-flex justify-content-between">
                              <strong>Total</strong>
                              <strong>₹ {{ number_format($order->total_amount,2) }}</strong>
                         </div>

                    </div>

                    {{-- PAYMENT --}}
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Payment</h4>
                         </div>
                         <div class="card-body">

                              <p>Method : {{ $order->payment_method }}</p>
                              <p>Status :
                                   @if($order->payment_status=='paid')
                                   <span class="badge bg-success">Paid</span>
                                   @else
                                   <span class="badge bg-warning">Pending</span>
                                   @endif
                              </p>

                         </div>
                    </div>

                    {{-- SHIPPING --}}
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Shipping Address</h4>
                         </div>
                         <div class="card-body">

                              @if($order->shippingAddress)

                              <p>{{ $order->shippingAddress->name }}</p>
                              <p>{{ $order->shippingAddress->address_line1 }}</p>
                              <p>{{ $order->shippingAddress->city }}</p>
                              <p>{{ $order->shippingAddress->state }}</p>
                              <p>{{ $order->shippingAddress->phone }}</p>

                              @endif

                         </div>
                    </div>

                    {{-- COURIER --}}
                    @if($order->courier)
                    <div class="card">
                         <div class="card-header">
                              <h4 class="card-title">Courier</h4>
                         </div>

                         <div class="card-body">

                              @if($order->courier->logo)
                              <img src="{{ asset($order->courier->logo) }}" width="80" class="mb-2" />
                              @endif

                              <p>{{ $order->courier->name }}</p>
                              <p>Tracking ID : {{ $order->tracking_id }}</p>

                              @if($order->courier->website)
                              <a href="{{ $order->courier->website }}" target="_blank">Track Shipment</a>
                              @endif

                         </div>
                    </div>
                    @endif

               </div>

          </div>
     </div>
</div>
<script>
$(document).on('click','.refundOrder',function(){

    let id = $(this).data('id');

    let url = "{{ route('orders.refund',':id') }}";
    url = url.replace(':id',id);

    $.post(url,{
        _token:'{{ csrf_token() }}'
    },function(res){

        Swal.fire('Success',res.message,'success');
        location.reload();

    });

});

$(document).on('click','.returnOrder',function(){

    let id = $(this).data('id');

    let url = "{{ route('orders.return',':id') }}";
    url = url.replace(':id',id);

    $.post(url,{
        _token:'{{ csrf_token() }}'
    },function(res){

        Swal.fire('Done',res.message,'success');
        location.reload();

    });

});

$(document).on('click','.editOrder',function(){

    let id = $(this).data('id');

    let url = "{{ route('orders.update',':id') }}";
    url = url.replace(':id',id);

    $.post(url,{
        _token:'{{ csrf_token() }}',
        status:'updated'
    },function(res){

        Swal.fire('Updated',res.message,'success');
        location.reload();

    });

});

$(document).on('click','.updateStatus',function(){

    let id = $(this).data('id');
    let status = $(this).data('status');

    let url = "{{ route('orders.status',':id') }}";
    url = url.replace(':id',id);

    $.post(url,{
        _token:'{{ csrf_token() }}',
        status:status
    },function(res){

        Swal.fire('Success',res.message,'success');
        location.reload();

    });

});



</script>
@php
$progress = [
    'placed'=>20,
    'processing'=>40,
    'shipping'=>70,
    'delivered'=>100,
    'returned'=>100,
    'refunded'=>100
];
@endphp
<div class="progress">
    <div class="progress-bar" style="width:50%">
        {{ ucfirst($order->status) }}
    </div>
</div>


@endsection